// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// ResourceTypeAliasPath.
/// </summary>
public partial class ResourceTypeAliasPath : ProvisionableConstruct
{
    /// <summary>
    /// Gets the Path.
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// Gets the ApiVersions.
    /// </summary>
    public BicepList<string> ApiVersions 
    {
        get { Initialize(); return _apiVersions!; }
    }
    private BicepList<string>? _apiVersions;

    /// <summary>
    /// Gets the Pattern.
    /// </summary>
    public ResourceTypeAliasPattern Pattern 
    {
        get { Initialize(); return _pattern!; }
    }
    private ResourceTypeAliasPattern? _pattern;

    /// <summary>
    /// Gets the Metadata.
    /// </summary>
    public ResourceTypeAliasPathMetadata Metadata 
    {
        get { Initialize(); return _metadata!; }
    }
    private ResourceTypeAliasPathMetadata? _metadata;

    /// <summary>
    /// Creates a new ResourceTypeAliasPath.
    /// </summary>
    public ResourceTypeAliasPath()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ResourceTypeAliasPath.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _path = DefineProperty<string>("Path", ["path"], isOutput: true);
        _apiVersions = DefineListProperty<string>("ApiVersions", ["apiVersions"], isOutput: true);
        _pattern = DefineModelProperty<ResourceTypeAliasPattern>("Pattern", ["pattern"], isOutput: true);
        _metadata = DefineModelProperty<ResourceTypeAliasPathMetadata>("Metadata", ["metadata"], isOutput: true);
    }
}
