// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// ResourceTypeAlias.
/// </summary>
public partial class ResourceTypeAlias : ProvisionableConstruct
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets the Paths.
    /// </summary>
    public BicepList<ResourceTypeAliasPath> Paths 
    {
        get { Initialize(); return _paths!; }
    }
    private BicepList<ResourceTypeAliasPath>? _paths;

    /// <summary>
    /// Gets the AliasType.
    /// </summary>
    public BicepValue<ResourceTypeAliasType> AliasType 
    {
        get { Initialize(); return _aliasType!; }
    }
    private BicepValue<ResourceTypeAliasType>? _aliasType;

    /// <summary>
    /// Gets the DefaultPath.
    /// </summary>
    public BicepValue<string> DefaultPath 
    {
        get { Initialize(); return _defaultPath!; }
    }
    private BicepValue<string>? _defaultPath;

    /// <summary>
    /// Gets the DefaultPattern.
    /// </summary>
    public ResourceTypeAliasPattern DefaultPattern 
    {
        get { Initialize(); return _defaultPattern!; }
    }
    private ResourceTypeAliasPattern? _defaultPattern;

    /// <summary>
    /// Gets the DefaultMetadata.
    /// </summary>
    public ResourceTypeAliasPathMetadata DefaultMetadata 
    {
        get { Initialize(); return _defaultMetadata!; }
    }
    private ResourceTypeAliasPathMetadata? _defaultMetadata;

    /// <summary>
    /// Creates a new ResourceTypeAlias.
    /// </summary>
    public ResourceTypeAlias()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ResourceTypeAlias.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _paths = DefineListProperty<ResourceTypeAliasPath>("Paths", ["paths"], isOutput: true);
        _aliasType = DefineProperty<ResourceTypeAliasType>("AliasType", ["type"], isOutput: true);
        _defaultPath = DefineProperty<string>("DefaultPath", ["defaultPath"], isOutput: true);
        _defaultPattern = DefineModelProperty<ResourceTypeAliasPattern>("DefaultPattern", ["defaultPattern"], isOutput: true);
        _defaultMetadata = DefineModelProperty<ResourceTypeAliasPathMetadata>("DefaultMetadata", ["defaultMetadata"], isOutput: true);
    }
}
