// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

using System.Runtime.Serialization;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The selector kind.
/// </summary>
public enum ResourceSelectorKind
{
    /// <summary>
    /// The selector kind to filter policies by the resource location.
    /// </summary>
    [DataMember(Name = "resourceLocation")]
    ResourceLocation,

    /// <summary>
    /// The selector kind to filter policies by the resource type.
    /// </summary>
    [DataMember(Name = "resourceType")]
    ResourceType,

    /// <summary>
    /// The selector kind to filter policies by the resource without location.
    /// </summary>
    [DataMember(Name = "resourceWithoutLocation")]
    ResourceWithoutLocation,

    /// <summary>
    /// The selector kind to filter policies by the policy definition reference
    /// ID.
    /// </summary>
    [DataMember(Name = "policyDefinitionReferenceId")]
    PolicyDefinitionReferenceId,
}
