// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The selector expression.
/// </summary>
public partial class ResourceSelectorExpression : ProvisionableConstruct
{
    /// <summary>
    /// The selector kind.
    /// </summary>
    public BicepValue<ResourceSelectorKind> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<ResourceSelectorKind>? _kind;

    /// <summary>
    /// The list of values to filter in.
    /// </summary>
    public BicepList<string> In 
    {
        get { Initialize(); return _in!; }
        set { Initialize(); _in!.Assign(value); }
    }
    private BicepList<string>? _in;

    /// <summary>
    /// The list of values to filter out.
    /// </summary>
    public BicepList<string> NotIn 
    {
        get { Initialize(); return _notIn!; }
        set { Initialize(); _notIn!.Assign(value); }
    }
    private BicepList<string>? _notIn;

    /// <summary>
    /// Creates a new ResourceSelectorExpression.
    /// </summary>
    public ResourceSelectorExpression()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ResourceSelectorExpression.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _kind = DefineProperty<ResourceSelectorKind>("Kind", ["kind"]);
        _in = DefineListProperty<string>("In", ["in"]);
        _notIn = DefineListProperty<string>("NotIn", ["notIn"]);
    }
}
