// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The resource selector to filter policies by resource properties.
/// </summary>
public partial class ResourceSelector : ProvisionableConstruct
{
    /// <summary>
    /// The name of the resource selector.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The list of the selector expressions.
    /// </summary>
    public BicepList<ResourceSelectorExpression> Selectors 
    {
        get { Initialize(); return _selectors!; }
        set { Initialize(); _selectors!.Assign(value); }
    }
    private BicepList<ResourceSelectorExpression>? _selectors;

    /// <summary>
    /// Creates a new ResourceSelector.
    /// </summary>
    public ResourceSelector()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ResourceSelector.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _selectors = DefineListProperty<ResourceSelectorExpression>("Selectors", ["selectors"]);
    }
}
