// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// ProviderResourceType.
/// </summary>
public partial class ProviderResourceType : ProvisionableConstruct
{
    /// <summary>
    /// Gets the ResourceType.
    /// </summary>
    public BicepValue<string> ResourceType 
    {
        get { Initialize(); return _resourceType!; }
    }
    private BicepValue<string>? _resourceType;

    /// <summary>
    /// Gets the Locations.
    /// </summary>
    public BicepList<string> Locations 
    {
        get { Initialize(); return _locations!; }
    }
    private BicepList<string>? _locations;

    /// <summary>
    /// Gets the LocationMappings.
    /// </summary>
    public BicepList<ProviderExtendedLocation> LocationMappings 
    {
        get { Initialize(); return _locationMappings!; }
    }
    private BicepList<ProviderExtendedLocation>? _locationMappings;

    /// <summary>
    /// Gets the Aliases.
    /// </summary>
    public BicepList<ResourceTypeAlias> Aliases 
    {
        get { Initialize(); return _aliases!; }
    }
    private BicepList<ResourceTypeAlias>? _aliases;

    /// <summary>
    /// Gets the ApiVersions.
    /// </summary>
    public BicepList<string> ApiVersions 
    {
        get { Initialize(); return _apiVersions!; }
    }
    private BicepList<string>? _apiVersions;

    /// <summary>
    /// Gets the DefaultApiVersion.
    /// </summary>
    public BicepValue<string> DefaultApiVersion 
    {
        get { Initialize(); return _defaultApiVersion!; }
    }
    private BicepValue<string>? _defaultApiVersion;

    /// <summary>
    /// Gets the ZoneMappings.
    /// </summary>
    public BicepList<ZoneMapping> ZoneMappings 
    {
        get { Initialize(); return _zoneMappings!; }
    }
    private BicepList<ZoneMapping>? _zoneMappings;

    /// <summary>
    /// Gets the ApiProfiles.
    /// </summary>
    public BicepList<ApiProfile> ApiProfiles 
    {
        get { Initialize(); return _apiProfiles!; }
    }
    private BicepList<ApiProfile>? _apiProfiles;

    /// <summary>
    /// Gets the Capabilities.
    /// </summary>
    public BicepValue<string> Capabilities 
    {
        get { Initialize(); return _capabilities!; }
    }
    private BicepValue<string>? _capabilities;

    /// <summary>
    /// Gets the Properties.
    /// </summary>
    public BicepDictionary<string> Properties 
    {
        get { Initialize(); return _properties!; }
    }
    private BicepDictionary<string>? _properties;

    /// <summary>
    /// Creates a new ProviderResourceType.
    /// </summary>
    public ProviderResourceType()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ProviderResourceType.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _resourceType = DefineProperty<string>("ResourceType", ["resourceType"], isOutput: true);
        _locations = DefineListProperty<string>("Locations", ["locations"], isOutput: true);
        _locationMappings = DefineListProperty<ProviderExtendedLocation>("LocationMappings", ["locationMappings"], isOutput: true);
        _aliases = DefineListProperty<ResourceTypeAlias>("Aliases", ["aliases"], isOutput: true);
        _apiVersions = DefineListProperty<string>("ApiVersions", ["apiVersions"], isOutput: true);
        _defaultApiVersion = DefineProperty<string>("DefaultApiVersion", ["defaultApiVersion"], isOutput: true);
        _zoneMappings = DefineListProperty<ZoneMapping>("ZoneMappings", ["zoneMappings"], isOutput: true);
        _apiProfiles = DefineListProperty<ApiProfile>("ApiProfiles", ["apiProfiles"], isOutput: true);
        _capabilities = DefineProperty<string>("Capabilities", ["capabilities"], isOutput: true);
        _properties = DefineDictionaryProperty<string>("Properties", ["properties"], isOutput: true);
    }
}
