// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// ProviderExtendedLocation.
/// </summary>
public partial class ProviderExtendedLocation : ProvisionableConstruct
{
    /// <summary>
    /// Gets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Gets the ProviderExtendedLocationType.
    /// </summary>
    public BicepValue<string> ProviderExtendedLocationType 
    {
        get { Initialize(); return _providerExtendedLocationType!; }
    }
    private BicepValue<string>? _providerExtendedLocationType;

    /// <summary>
    /// Gets the ExtendedLocations.
    /// </summary>
    public BicepList<string> ExtendedLocations 
    {
        get { Initialize(); return _extendedLocations!; }
    }
    private BicepList<string>? _extendedLocations;

    /// <summary>
    /// Creates a new ProviderExtendedLocation.
    /// </summary>
    public ProviderExtendedLocation()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ProviderExtendedLocation.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _providerExtendedLocationType = DefineProperty<string>("ProviderExtendedLocationType", ["type"], isOutput: true);
        _extendedLocations = DefineListProperty<string>("ExtendedLocations", ["extendedLocations"], isOutput: true);
    }
}
