// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The policy definition group.
/// </summary>
public partial class PolicyDefinitionGroup : ProvisionableConstruct
{
    /// <summary>
    /// The name of the group.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The group&apos;s display name.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
        set { Initialize(); _displayName!.Assign(value); }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// The group&apos;s category.
    /// </summary>
    public BicepValue<string> Category 
    {
        get { Initialize(); return _category!; }
        set { Initialize(); _category!.Assign(value); }
    }
    private BicepValue<string>? _category;

    /// <summary>
    /// The group&apos;s description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// A resource ID of a resource that contains additional metadata about the
    /// group.
    /// </summary>
    public BicepValue<string> AdditionalMetadataId 
    {
        get { Initialize(); return _additionalMetadataId!; }
        set { Initialize(); _additionalMetadataId!.Assign(value); }
    }
    private BicepValue<string>? _additionalMetadataId;

    /// <summary>
    /// Creates a new PolicyDefinitionGroup.
    /// </summary>
    public PolicyDefinitionGroup()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PolicyDefinitionGroup.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _displayName = DefineProperty<string>("DisplayName", ["displayName"]);
        _category = DefineProperty<string>("Category", ["category"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _additionalMetadataId = DefineProperty<string>("AdditionalMetadataId", ["additionalMetadataId"]);
    }
}
