// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// Expanded info of resource scope, role definition and policy.
/// </summary>
public partial class PolicyAssignmentProperties : ProvisionableConstruct
{
    /// <summary>
    /// Id of the policy.
    /// </summary>
    public BicepValue<ResourceIdentifier> PolicyId 
    {
        get { Initialize(); return _policyId!; }
    }
    private BicepValue<ResourceIdentifier>? _policyId;

    /// <summary>
    /// The name of the entity last modified it.
    /// </summary>
    public RoleManagementPrincipal LastModifiedBy 
    {
        get { Initialize(); return _lastModifiedBy!; }
    }
    private RoleManagementPrincipal? _lastModifiedBy;

    /// <summary>
    /// The last modified date time.
    /// </summary>
    public BicepValue<DateTimeOffset> LastModifiedOn 
    {
        get { Initialize(); return _lastModifiedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastModifiedOn;

    /// <summary>
    /// Id of the role definition.
    /// </summary>
    public BicepValue<ResourceIdentifier> RoleDefinitionId 
    {
        get { Initialize(); return _roleDefinitionId!; }
    }
    private BicepValue<ResourceIdentifier>? _roleDefinitionId;

    /// <summary>
    /// Display name of the role definition.
    /// </summary>
    public BicepValue<string> RoleDefinitionDisplayName 
    {
        get { Initialize(); return _roleDefinitionDisplayName!; }
    }
    private BicepValue<string>? _roleDefinitionDisplayName;

    /// <summary>
    /// The role type.
    /// </summary>
    public BicepValue<AuthorizationRoleType> RoleType 
    {
        get { Initialize(); return _roleType!; }
    }
    private BicepValue<AuthorizationRoleType>? _roleType;

    /// <summary>
    /// Scope id of the resource.
    /// </summary>
    public BicepValue<ResourceIdentifier> ScopeId 
    {
        get { Initialize(); return _scopeId!; }
    }
    private BicepValue<ResourceIdentifier>? _scopeId;

    /// <summary>
    /// Display name of the resource.
    /// </summary>
    public BicepValue<string> ScopeDisplayName 
    {
        get { Initialize(); return _scopeDisplayName!; }
    }
    private BicepValue<string>? _scopeDisplayName;

    /// <summary>
    /// Type of the scope.
    /// </summary>
    public BicepValue<RoleManagementScopeType> ScopeType 
    {
        get { Initialize(); return _scopeType!; }
    }
    private BicepValue<RoleManagementScopeType>? _scopeType;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new PolicyAssignmentProperties.
    /// </summary>
    public PolicyAssignmentProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PolicyAssignmentProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _policyId = DefineProperty<ResourceIdentifier>("PolicyId", ["policy", "id"], isOutput: true);
        _lastModifiedBy = DefineModelProperty<RoleManagementPrincipal>("LastModifiedBy", ["policy", "lastModifiedBy"], isOutput: true);
        _lastModifiedOn = DefineProperty<DateTimeOffset>("LastModifiedOn", ["policy", "lastModifiedDateTime"], isOutput: true);
        _roleDefinitionId = DefineProperty<ResourceIdentifier>("RoleDefinitionId", ["roleDefinition", "id"], isOutput: true);
        _roleDefinitionDisplayName = DefineProperty<string>("RoleDefinitionDisplayName", ["roleDefinition", "displayName"], isOutput: true);
        _roleType = DefineProperty<AuthorizationRoleType>("RoleType", ["roleDefinition", "type"], isOutput: true);
        _scopeId = DefineProperty<ResourceIdentifier>("ScopeId", ["scope", "id"], isOutput: true);
        _scopeDisplayName = DefineProperty<string>("ScopeDisplayName", ["scope", "displayName"], isOutput: true);
        _scopeType = DefineProperty<RoleManagementScopeType>("ScopeType", ["scope", "type"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }
}
