// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// (Optional) The ID of the parent management group.
/// </summary>
public partial class ParentManagementGroupInfo : ProvisionableConstruct
{
    /// <summary>
    /// The fully qualified ID for the parent management group.  For example,
    /// /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// The name of the parent management group.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The friendly name of the parent management group.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// Creates a new ParentManagementGroupInfo.
    /// </summary>
    public ParentManagementGroupInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ParentManagementGroupInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _displayName = DefineProperty<string>("DisplayName", ["displayName"], isOutput: true);
    }
}
