// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// General metadata for the parameter.
/// </summary>
public partial class ParameterDefinitionsValueMetadata : ProvisionableConstruct
{
    /// <summary>
    /// The display name for the parameter.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
        set { Initialize(); _displayName!.Assign(value); }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// The description of the parameter.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Used when assigning the policy definition through the portal. Provides
    /// a context aware list of values for the user to choose from.
    /// </summary>
    public BicepValue<string> StrongType 
    {
        get { Initialize(); return _strongType!; }
        set { Initialize(); _strongType!.Assign(value); }
    }
    private BicepValue<string>? _strongType;

    /// <summary>
    /// Set to true to have Azure portal create role assignments on the
    /// resource ID or resource scope value of this parameter during policy
    /// assignment. This property is useful in case you wish to assign
    /// permissions outside the assignment scope.
    /// </summary>
    public BicepValue<bool> AssignPermissions 
    {
        get { Initialize(); return _assignPermissions!; }
        set { Initialize(); _assignPermissions!.Assign(value); }
    }
    private BicepValue<bool>? _assignPermissions;

    /// <summary>
    /// Additional Properties                          To assign an object to
    /// the value of this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepDictionary<BinaryData> AdditionalProperties 
    {
        get { Initialize(); return _additionalProperties!; }
        set { Initialize(); _additionalProperties!.Assign(value); }
    }
    private BicepDictionary<BinaryData>? _additionalProperties;

    /// <summary>
    /// Creates a new ParameterDefinitionsValueMetadata.
    /// </summary>
    public ParameterDefinitionsValueMetadata()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ParameterDefinitionsValueMetadata.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _displayName = DefineProperty<string>("DisplayName", ["displayName"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _strongType = DefineProperty<string>("StrongType", ["strongType"]);
        _assignPermissions = DefineProperty<bool>("AssignPermissions", ["assignPermissions"]);
        _additionalProperties = DefineDictionaryProperty<BinaryData>("AdditionalProperties", ["AdditionalProperties"]);
    }
}
