// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// A message that describes why a resource is non-compliant with the policy.
/// This is shown in &apos;deny&apos; error messages and on resource&apos;s
/// non-compliant compliance results.
/// </summary>
public partial class NonComplianceMessage : ProvisionableConstruct
{
    /// <summary>
    /// A message that describes why a resource is non-compliant with the
    /// policy. This is shown in &apos;deny&apos; error messages and on
    /// resource&apos;s non-compliant compliance results.
    /// </summary>
    public BicepValue<string> Message 
    {
        get { Initialize(); return _message!; }
        set { Initialize(); _message!.Assign(value); }
    }
    private BicepValue<string>? _message;

    /// <summary>
    /// The policy definition reference ID within a policy set definition the
    /// message is intended for. This is only applicable if the policy
    /// assignment assigns a policy set definition. If this is not provided
    /// the message applies to all policies assigned by this policy assignment.
    /// </summary>
    public BicepValue<string> PolicyDefinitionReferenceId 
    {
        get { Initialize(); return _policyDefinitionReferenceId!; }
        set { Initialize(); _policyDefinitionReferenceId!.Assign(value); }
    }
    private BicepValue<string>? _policyDefinitionReferenceId;

    /// <summary>
    /// Creates a new NonComplianceMessage.
    /// </summary>
    public NonComplianceMessage()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of NonComplianceMessage.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _message = DefineProperty<string>("Message", ["message"]);
        _policyDefinitionReferenceId = DefineProperty<string>("PolicyDefinitionReferenceId", ["policyDefinitionReferenceId"]);
    }
}
