// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Lock owner properties.
/// </summary>
public partial class ManagementLockOwner : ProvisionableConstruct
{
    /// <summary>
    /// The application ID of the lock owner.
    /// </summary>
    public BicepValue<string> ApplicationId 
    {
        get { Initialize(); return _applicationId!; }
        set { Initialize(); _applicationId!.Assign(value); }
    }
    private BicepValue<string>? _applicationId;

    /// <summary>
    /// Creates a new ManagementLockOwner.
    /// </summary>
    public ManagementLockOwner()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementLockOwner.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _applicationId = DefineProperty<string>("ApplicationId", ["applicationId"]);
    }
}
