// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// A path element of a management group ancestors.
/// </summary>
public partial class ManagementGroupPathElement : ProvisionableConstruct
{
    /// <summary>
    /// The name of the group.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The friendly name of the group.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// Creates a new ManagementGroupPathElement.
    /// </summary>
    public ManagementGroupPathElement()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementGroupPathElement.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _displayName = DefineProperty<string>("DisplayName", ["displayName"], isOutput: true);
    }
}
