// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The details of a management group.
/// </summary>
public partial class ManagementGroupInfo : ProvisionableConstruct
{
    /// <summary>
    /// The version number of the object.
    /// </summary>
    public BicepValue<int> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<int>? _version;

    /// <summary>
    /// The date and time when this object was last updated.
    /// </summary>
    public BicepValue<DateTimeOffset> UpdatedOn 
    {
        get { Initialize(); return _updatedOn!; }
    }
    private BicepValue<DateTimeOffset>? _updatedOn;

    /// <summary>
    /// The identity of the principal or process that updated the object.
    /// </summary>
    public BicepValue<string> UpdatedBy 
    {
        get { Initialize(); return _updatedBy!; }
    }
    private BicepValue<string>? _updatedBy;

    /// <summary>
    /// (Optional) The ID of the parent management group.
    /// </summary>
    public ParentManagementGroupInfo Parent 
    {
        get { Initialize(); return _parent!; }
    }
    private ParentManagementGroupInfo? _parent;

    /// <summary>
    /// The path from the root to the current group.
    /// </summary>
    public BicepList<ManagementGroupPathElement> Path 
    {
        get { Initialize(); return _path!; }
    }
    private BicepList<ManagementGroupPathElement>? _path;

    /// <summary>
    /// The ancestors of the management group.
    /// </summary>
    public BicepList<string> ManagementGroupAncestors 
    {
        get { Initialize(); return _managementGroupAncestors!; }
    }
    private BicepList<string>? _managementGroupAncestors;

    /// <summary>
    /// The ancestors of the management group displayed in reversed order, from
    /// immediate parent to the root.
    /// </summary>
    public BicepList<ManagementGroupPathElement> ManagementGroupAncestorChain 
    {
        get { Initialize(); return _managementGroupAncestorChain!; }
    }
    private BicepList<ManagementGroupPathElement>? _managementGroupAncestorChain;

    /// <summary>
    /// Creates a new ManagementGroupInfo.
    /// </summary>
    public ManagementGroupInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementGroupInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _version = DefineProperty<int>("Version", ["version"], isOutput: true);
        _updatedOn = DefineProperty<DateTimeOffset>("UpdatedOn", ["updatedTime"], isOutput: true);
        _updatedBy = DefineProperty<string>("UpdatedBy", ["updatedBy"], isOutput: true);
        _parent = DefineModelProperty<ParentManagementGroupInfo>("Parent", ["parent"], isOutput: true);
        _path = DefineListProperty<ManagementGroupPathElement>("Path", ["path"], isOutput: true);
        _managementGroupAncestors = DefineListProperty<string>("ManagementGroupAncestors", ["managementGroupAncestors"], isOutput: true);
        _managementGroupAncestorChain = DefineListProperty<ManagementGroupPathElement>("ManagementGroupAncestorChain", ["managementGroupAncestorsChain"], isOutput: true);
    }
}
