// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The child information of a management group used during creation.
/// </summary>
public partial class ManagementGroupChildOptions : ProvisionableConstruct
{
    /// <summary>
    /// The fully qualified resource type which includes provider namespace
    /// (e.g. Microsoft.Management/managementGroups).
    /// </summary>
    public BicepValue<ManagementGroupChildType> ChildType 
    {
        get { Initialize(); return _childType!; }
    }
    private BicepValue<ManagementGroupChildType>? _childType;

    /// <summary>
    /// The fully qualified ID for the child resource (management group or
    /// subscription).  For example,
    /// /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// The name of the child entity.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The friendly name of the child resource.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// The list of children.
    /// </summary>
    public BicepList<ManagementGroupChildOptions> Children 
    {
        get { Initialize(); return _children!; }
    }
    private BicepList<ManagementGroupChildOptions>? _children;

    /// <summary>
    /// Creates a new ManagementGroupChildOptions.
    /// </summary>
    public ManagementGroupChildOptions()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementGroupChildOptions.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _childType = DefineProperty<ManagementGroupChildType>("ChildType", ["type"], isOutput: true);
        _id = DefineProperty<string>("Id", ["id"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _displayName = DefineProperty<string>("DisplayName", ["displayName"], isOutput: true);
        _children = DefineListProperty<ManagementGroupChildOptions>("Children", ["children"], isOutput: true);
    }
}
