// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Managed service identity (system assigned and/or user assigned identities).
/// </summary>
public partial class ManagedServiceIdentity : ProvisionableConstruct
{
    /// <summary>
    /// The service principal ID of the system assigned identity. This property
    /// will only be provided for a system assigned identity.
    /// </summary>
    public BicepValue<Guid> PrincipalId 
    {
        get { Initialize(); return _principalId!; }
    }
    private BicepValue<Guid>? _principalId;

    /// <summary>
    /// The tenant ID of the system assigned identity. This property will only
    /// be provided for a system assigned identity.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Type of managed service identity (where both SystemAssigned and
    /// UserAssigned types are allowed).
    /// </summary>
    public BicepValue<ManagedServiceIdentityType> ManagedServiceIdentityType 
    {
        get { Initialize(); return _managedServiceIdentityType!; }
        set { Initialize(); _managedServiceIdentityType!.Assign(value); }
    }
    private BicepValue<ManagedServiceIdentityType>? _managedServiceIdentityType;

    /// <summary>
    /// The set of user assigned identities associated with the resource. The
    /// userAssignedIdentities dictionary keys will be ARM resource ids in the
    /// form:
    /// &apos;/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
    /// The dictionary values can be empty objects ({}) in requests.
    /// </summary>
    public BicepDictionary<UserAssignedIdentityDetails> UserAssignedIdentities 
    {
        get { Initialize(); return _userAssignedIdentities!; }
        set { Initialize(); _userAssignedIdentities!.Assign(value); }
    }
    private BicepDictionary<UserAssignedIdentityDetails>? _userAssignedIdentities;

    /// <summary>
    /// Creates a new ManagedServiceIdentity.
    /// </summary>
    public ManagedServiceIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedServiceIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _principalId = DefineProperty<Guid>("PrincipalId", ["principalId"], isOutput: true);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"], isOutput: true);
        _managedServiceIdentityType = DefineProperty<ManagedServiceIdentityType>("ManagedServiceIdentityType", ["type"]);
        _userAssignedIdentities = DefineDictionaryProperty<UserAssignedIdentityDetails>("UserAssignedIdentities", ["userAssignedIdentities"]);
    }
}
