// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Represents a Template Spec artifact containing an embedded Azure Resource
/// Manager template for use as a linked template.
/// </summary>
public partial class LinkedTemplateArtifact : ProvisionableConstruct
{
    /// <summary>
    /// A filesystem safe relative path of the artifact.
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
        set { Initialize(); _path!.Assign(value); }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// The Azure Resource Manager template.                          To assign
    /// an object to this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepValue<BinaryData> Template 
    {
        get { Initialize(); return _template!; }
        set { Initialize(); _template!.Assign(value); }
    }
    private BicepValue<BinaryData>? _template;

    /// <summary>
    /// Creates a new LinkedTemplateArtifact.
    /// </summary>
    public LinkedTemplateArtifact()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of LinkedTemplateArtifact.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _path = DefineProperty<string>("Path", ["path"]);
        _template = DefineProperty<BinaryData>("Template", ["template"]);
    }
}
