// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The JIT scheduling policies.
/// </summary>
public partial class JitSchedulingPolicy : ProvisionableConstruct
{
    /// <summary>
    /// The type of JIT schedule.
    /// </summary>
    public BicepValue<JitSchedulingType> SchedulingType 
    {
        get { Initialize(); return _schedulingType!; }
    }
    private BicepValue<JitSchedulingType>? _schedulingType;

    /// <summary>
    /// The required duration of the JIT request.
    /// </summary>
    public BicepValue<TimeSpan> Duration 
    {
        get { Initialize(); return _duration!; }
        set { Initialize(); _duration!.Assign(value); }
    }
    private BicepValue<TimeSpan>? _duration;

    /// <summary>
    /// The start time of the request.
    /// </summary>
    public BicepValue<DateTimeOffset> StartOn 
    {
        get { Initialize(); return _startOn!; }
        set { Initialize(); _startOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _startOn;

    /// <summary>
    /// Creates a new JitSchedulingPolicy.
    /// </summary>
    public JitSchedulingPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of JitSchedulingPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _schedulingType = DefineProperty<JitSchedulingType>("SchedulingType", ["type"], isOutput: true);
        _duration = DefineProperty<TimeSpan>("Duration", ["duration"], format: "P");
        _startOn = DefineProperty<DateTimeOffset>("StartOn", ["startTime"]);
    }
}
