// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The JIT authorization policies.
/// </summary>
public partial class JitAuthorizationPolicies : ProvisionableConstruct
{
    /// <summary>
    /// The the principal id that will be granted JIT access.
    /// </summary>
    public BicepValue<Guid> PrincipalId 
    {
        get { Initialize(); return _principalId!; }
        set { Initialize(); _principalId!.Assign(value); }
    }
    private BicepValue<Guid>? _principalId;

    /// <summary>
    /// The role definition id that will be granted to the Principal.
    /// </summary>
    public BicepValue<string> RoleDefinitionId 
    {
        get { Initialize(); return _roleDefinitionId!; }
        set { Initialize(); _roleDefinitionId!.Assign(value); }
    }
    private BicepValue<string>? _roleDefinitionId;

    /// <summary>
    /// Creates a new JitAuthorizationPolicies.
    /// </summary>
    public JitAuthorizationPolicies()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of JitAuthorizationPolicies.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _principalId = DefineProperty<Guid>("PrincipalId", ["principalId"]);
        _roleDefinitionId = DefineProperty<string>("RoleDefinitionId", ["roleDefinitionId"]);
    }
}
