// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// JIT approver definition.
/// </summary>
public partial class JitApprover : ProvisionableConstruct
{
    /// <summary>
    /// The approver service principal Id.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// The approver type.
    /// </summary>
    public BicepValue<JitApproverType> ApproverType 
    {
        get { Initialize(); return _approverType!; }
        set { Initialize(); _approverType!.Assign(value); }
    }
    private BicepValue<JitApproverType>? _approverType;

    /// <summary>
    /// The approver display name.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
        set { Initialize(); _displayName!.Assign(value); }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// Creates a new JitApprover.
    /// </summary>
    public JitApprover()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of JitApprover.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"]);
        _approverType = DefineProperty<JitApproverType>("ApproverType", ["type"]);
        _displayName = DefineProperty<string>("DisplayName", ["displayName"]);
    }
}
