// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Deployment on error behavior with additional details.
/// </summary>
public partial class ErrorDeploymentExtended : ProvisionableConstruct
{
    /// <summary>
    /// The state of the provisioning for the on error deployment.
    /// </summary>
    public BicepValue<string> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<string>? _provisioningState;

    /// <summary>
    /// The deployment on error behavior type. Possible values are
    /// LastSuccessful and SpecificDeployment.
    /// </summary>
    public BicepValue<ErrorDeploymentType> DeploymentType 
    {
        get { Initialize(); return _deploymentType!; }
    }
    private BicepValue<ErrorDeploymentType>? _deploymentType;

    /// <summary>
    /// The deployment to be used on error case.
    /// </summary>
    public BicepValue<string> DeploymentName 
    {
        get { Initialize(); return _deploymentName!; }
    }
    private BicepValue<string>? _deploymentName;

    /// <summary>
    /// Creates a new ErrorDeploymentExtended.
    /// </summary>
    public ErrorDeploymentExtended()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ErrorDeploymentExtended.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _provisioningState = DefineProperty<string>("ProvisioningState", ["provisioningState"], isOutput: true);
        _deploymentType = DefineProperty<ErrorDeploymentType>("DeploymentType", ["type"], isOutput: true);
        _deploymentName = DefineProperty<string>("DeploymentName", ["deploymentName"], isOutput: true);
    }
}
