// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The details of a management group used during creation.
/// </summary>
public partial class CreateManagementGroupDetails : ProvisionableConstruct
{
    /// <summary>
    /// The version number of the object.
    /// </summary>
    public BicepValue<int> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<int>? _version;

    /// <summary>
    /// The date and time when this object was last updated.
    /// </summary>
    public BicepValue<DateTimeOffset> UpdatedOn 
    {
        get { Initialize(); return _updatedOn!; }
    }
    private BicepValue<DateTimeOffset>? _updatedOn;

    /// <summary>
    /// The identity of the principal or process that updated the object.
    /// </summary>
    public BicepValue<string> UpdatedBy 
    {
        get { Initialize(); return _updatedBy!; }
    }
    private BicepValue<string>? _updatedBy;

    /// <summary>
    /// (Optional) The ID of the parent management group used during creation.
    /// </summary>
    public ManagementGroupParentCreateOptions Parent 
    {
        get { Initialize(); return _parent!; }
        set { Initialize(); AssignOrReplace(ref _parent, value); }
    }
    private ManagementGroupParentCreateOptions? _parent;

    /// <summary>
    /// Creates a new CreateManagementGroupDetails.
    /// </summary>
    public CreateManagementGroupDetails()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CreateManagementGroupDetails.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _version = DefineProperty<int>("Version", ["version"], isOutput: true);
        _updatedOn = DefineProperty<DateTimeOffset>("UpdatedOn", ["updatedTime"], isOutput: true);
        _updatedBy = DefineProperty<string>("UpdatedBy", ["updatedBy"], isOutput: true);
        _parent = DefineModelProperty<ManagementGroupParentCreateOptions>("Parent", ["parent"]);
    }
}
