// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The definition of a parameter that can be provided to the policy.
/// </summary>
public partial class ArmPolicyParameter : ProvisionableConstruct
{
    /// <summary>
    /// The data type of the parameter.
    /// </summary>
    public BicepValue<ArmPolicyParameterType> ParameterType 
    {
        get { Initialize(); return _parameterType!; }
        set { Initialize(); _parameterType!.Assign(value); }
    }
    private BicepValue<ArmPolicyParameterType>? _parameterType;

    /// <summary>
    /// The allowed values for the parameter.                          To
    /// assign an object to the element of this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepList<BinaryData> AllowedValues 
    {
        get { Initialize(); return _allowedValues!; }
        set { Initialize(); _allowedValues!.Assign(value); }
    }
    private BicepList<BinaryData>? _allowedValues;

    /// <summary>
    /// The default value for the parameter if no value is provided.
    /// To assign an object to this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepValue<BinaryData> DefaultValue 
    {
        get { Initialize(); return _defaultValue!; }
        set { Initialize(); _defaultValue!.Assign(value); }
    }
    private BicepValue<BinaryData>? _defaultValue;

    /// <summary>
    /// General metadata for the parameter.
    /// </summary>
    public ParameterDefinitionsValueMetadata Metadata 
    {
        get { Initialize(); return _metadata!; }
        set { Initialize(); AssignOrReplace(ref _metadata, value); }
    }
    private ParameterDefinitionsValueMetadata? _metadata;

    /// <summary>
    /// Creates a new ArmPolicyParameter.
    /// </summary>
    public ArmPolicyParameter()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmPolicyParameter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _parameterType = DefineProperty<ArmPolicyParameterType>("ParameterType", ["type"]);
        _allowedValues = DefineListProperty<BinaryData>("AllowedValues", ["allowedValues"]);
        _defaultValue = DefineProperty<BinaryData>("DefaultValue", ["defaultValue"]);
        _metadata = DefineModelProperty<ParameterDefinitionsValueMetadata>("Metadata", ["metadata"]);
    }
}
