// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Representation of a publisher plan for marketplace RPs.
/// </summary>
public partial class ArmPlan : ProvisionableConstruct
{
    /// <summary>
    /// A user defined name of the 3rd Party Artifact that is being procured.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The publisher of the 3rd Party Artifact that is being bought. E.g.
    /// NewRelic.
    /// </summary>
    public BicepValue<string> Publisher 
    {
        get { Initialize(); return _publisher!; }
        set { Initialize(); _publisher!.Assign(value); }
    }
    private BicepValue<string>? _publisher;

    /// <summary>
    /// The 3rd Party artifact that is being procured. E.g. NewRelic. Product
    /// maps to the OfferID specified for the artifact at the time of Data
    /// Market onboarding.
    /// </summary>
    public BicepValue<string> Product 
    {
        get { Initialize(); return _product!; }
        set { Initialize(); _product!.Assign(value); }
    }
    private BicepValue<string>? _product;

    /// <summary>
    /// A publisher provided promotion code as provisioned in Data Market for
    /// the said product/artifact.
    /// </summary>
    public BicepValue<string> PromotionCode 
    {
        get { Initialize(); return _promotionCode!; }
        set { Initialize(); _promotionCode!.Assign(value); }
    }
    private BicepValue<string>? _promotionCode;

    /// <summary>
    /// The version of the desired product/artifact.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
        set { Initialize(); _version!.Assign(value); }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Creates a new ArmPlan.
    /// </summary>
    public ArmPlan()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmPlan.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _publisher = DefineProperty<string>("Publisher", ["publisher"]);
        _product = DefineProperty<string>("Product", ["product"]);
        _promotionCode = DefineProperty<string>("PromotionCode", ["promotionCode"]);
        _version = DefineProperty<string>("Version", ["version"]);
    }
}
