// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Entity representing the reference to the template.
/// </summary>
public partial class ArmDeploymentTemplateLink : ProvisionableConstruct
{
    /// <summary>
    /// The URI of the template to deploy. Use either the uri or id property,
    /// but not both.
    /// </summary>
    public BicepValue<Uri> Uri 
    {
        get { Initialize(); return _uri!; }
        set { Initialize(); _uri!.Assign(value); }
    }
    private BicepValue<Uri>? _uri;

    /// <summary>
    /// The resource id of a Template Spec. Use either the id or uri property,
    /// but not both.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// The relativePath property can be used to deploy a linked template at a
    /// location relative to the parent. If the parent template was linked
    /// with a TemplateSpec, this will reference an artifact in the
    /// TemplateSpec.  If the parent was linked with a URI, the child
    /// deployment will be a combination of the parent and relativePath URIs.
    /// </summary>
    public BicepValue<string> RelativePath 
    {
        get { Initialize(); return _relativePath!; }
        set { Initialize(); _relativePath!.Assign(value); }
    }
    private BicepValue<string>? _relativePath;

    /// <summary>
    /// If included, must match the ContentVersion in the template.
    /// </summary>
    public BicepValue<string> ContentVersion 
    {
        get { Initialize(); return _contentVersion!; }
        set { Initialize(); _contentVersion!.Assign(value); }
    }
    private BicepValue<string>? _contentVersion;

    /// <summary>
    /// The query string (for example, a SAS token) to be used with the
    /// templateLink URI.
    /// </summary>
    public BicepValue<string> QueryString 
    {
        get { Initialize(); return _queryString!; }
        set { Initialize(); _queryString!.Assign(value); }
    }
    private BicepValue<string>? _queryString;

    /// <summary>
    /// Creates a new ArmDeploymentTemplateLink.
    /// </summary>
    public ArmDeploymentTemplateLink()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmDeploymentTemplateLink.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _uri = DefineProperty<Uri>("Uri", ["uri"]);
        _id = DefineProperty<string>("Id", ["id"]);
        _relativePath = DefineProperty<string>("RelativePath", ["relativePath"]);
        _contentVersion = DefineProperty<string>("ContentVersion", ["contentVersion"]);
        _queryString = DefineProperty<string>("QueryString", ["queryString"]);
    }
}
