// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Managed identity generic object.
/// </summary>
public partial class ArmDeploymentScriptManagedIdentity : ProvisionableConstruct
{
    /// <summary>
    /// Type of the managed identity.
    /// </summary>
    public BicepValue<ArmDeploymentScriptManagedIdentityType> IdentityType 
    {
        get { Initialize(); return _identityType!; }
        set { Initialize(); _identityType!.Assign(value); }
    }
    private BicepValue<ArmDeploymentScriptManagedIdentityType>? _identityType;

    /// <summary>
    /// ID of the Azure Active Directory.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// The list of user-assigned managed identities associated with the
    /// resource. Key is the Azure resource Id of the managed identity.
    /// </summary>
    public BicepDictionary<UserAssignedIdentityDetails> UserAssignedIdentities 
    {
        get { Initialize(); return _userAssignedIdentities!; }
        set { Initialize(); _userAssignedIdentities!.Assign(value); }
    }
    private BicepDictionary<UserAssignedIdentityDetails>? _userAssignedIdentities;

    /// <summary>
    /// Creates a new ArmDeploymentScriptManagedIdentity.
    /// </summary>
    public ArmDeploymentScriptManagedIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ArmDeploymentScriptManagedIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _identityType = DefineProperty<ArmDeploymentScriptManagedIdentityType>("IdentityType", ["type"]);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"], isOutput: true);
        _userAssignedIdentities = DefineDictionaryProperty<UserAssignedIdentityDetails>("UserAssignedIdentities", ["userAssignedIdentities"]);
    }
}
