// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Entity representing the reference to the deployment parameters.
/// </summary>
public partial class ArmDeploymentParametersLink : ProvisionableConstruct
{
    /// <summary>
    /// The URI of the parameters file.
    /// </summary>
    public BicepValue<Uri> Uri 
    {
        get { Initialize(); return _uri!; }
        set { Initialize(); _uri!.Assign(value); }
    }
    private BicepValue<Uri>? _uri;

    /// <summary>
    /// If included, must match the ContentVersion in the template.
    /// </summary>
    public BicepValue<string> ContentVersion 
    {
        get { Initialize(); return _contentVersion!; }
        set { Initialize(); _contentVersion!.Assign(value); }
    }
    private BicepValue<string>? _contentVersion;

    /// <summary>
    /// Creates a new ArmDeploymentParametersLink.
    /// </summary>
    public ArmDeploymentParametersLink()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmDeploymentParametersLink.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _uri = DefineProperty<Uri>("Uri", ["uri"]);
        _contentVersion = DefineProperty<string>("ContentVersion", ["contentVersion"]);
    }
}
