// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Deployment operation parameters.
/// </summary>
public partial class ArmDeploymentContent : ProvisionableConstruct
{
    /// <summary>
    /// The location to store the deployment data.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// The deployment properties.
    /// </summary>
    public ArmDeploymentProperties Properties 
    {
        get { Initialize(); return _properties!; }
    }
    private ArmDeploymentProperties? _properties;

    /// <summary>
    /// Deployment tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Creates a new ArmDeploymentContent.
    /// </summary>
    public ArmDeploymentContent()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmDeploymentContent.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _location = DefineProperty<AzureLocation>("Location", ["location"]);
        _properties = DefineModelProperty<ArmDeploymentProperties>("Properties", ["properties"], isOutput: true);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
    }
}
