// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Deployment dependency information.
/// </summary>
public partial class ArmDependency : ProvisionableConstruct
{
    /// <summary>
    /// The list of dependencies.
    /// </summary>
    public BicepList<BasicArmDependency> DependsOn 
    {
        get { Initialize(); return _dependsOn!; }
    }
    private BicepList<BasicArmDependency>? _dependsOn;

    /// <summary>
    /// The ID of the dependency.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// The dependency resource type.
    /// </summary>
    public BicepValue<ResourceType> ResourceType 
    {
        get { Initialize(); return _resourceType!; }
    }
    private BicepValue<ResourceType>? _resourceType;

    /// <summary>
    /// The dependency resource name.
    /// </summary>
    public BicepValue<string> ResourceName 
    {
        get { Initialize(); return _resourceName!; }
    }
    private BicepValue<string>? _resourceName;

    /// <summary>
    /// Creates a new ArmDependency.
    /// </summary>
    public ArmDependency()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmDependency.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _dependsOn = DefineListProperty<BasicArmDependency>("DependsOn", ["dependsOn"], isOutput: true);
        _id = DefineProperty<string>("Id", ["id"], isOutput: true);
        _resourceType = DefineProperty<ResourceType>("ResourceType", ["resourceType"], isOutput: true);
        _resourceName = DefineProperty<string>("ResourceName", ["resourceName"], isOutput: true);
    }
}
