// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Represents the user assigned identity that is contained within the
/// UserAssignedIdentities dictionary on ResourceIdentity.
/// </summary>
public partial class ArmApplicationUserAssignedIdentity : ProvisionableConstruct
{
    /// <summary>
    /// The principal id of user assigned identity.
    /// </summary>
    public BicepValue<Guid> PrincipalId 
    {
        get { Initialize(); return _principalId!; }
    }
    private BicepValue<Guid>? _principalId;

    /// <summary>
    /// The tenant id of user assigned identity.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Creates a new ArmApplicationUserAssignedIdentity.
    /// </summary>
    public ArmApplicationUserAssignedIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ArmApplicationUserAssignedIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _principalId = DefineProperty<Guid>("PrincipalId", ["principalId"], isOutput: true);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"], isOutput: true);
    }
}
