// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// SKU for the resource.
/// </summary>
public partial class ArmApplicationSku : ProvisionableConstruct
{
    /// <summary>
    /// The SKU name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The SKU tier.
    /// </summary>
    public BicepValue<string> Tier 
    {
        get { Initialize(); return _tier!; }
        set { Initialize(); _tier!.Assign(value); }
    }
    private BicepValue<string>? _tier;

    /// <summary>
    /// The SKU size.
    /// </summary>
    public BicepValue<string> Size 
    {
        get { Initialize(); return _size!; }
        set { Initialize(); _size!.Assign(value); }
    }
    private BicepValue<string>? _size;

    /// <summary>
    /// The SKU family.
    /// </summary>
    public BicepValue<string> Family 
    {
        get { Initialize(); return _family!; }
        set { Initialize(); _family!.Assign(value); }
    }
    private BicepValue<string>? _family;

    /// <summary>
    /// The SKU model.
    /// </summary>
    public BicepValue<string> Model 
    {
        get { Initialize(); return _model!; }
        set { Initialize(); _model!.Assign(value); }
    }
    private BicepValue<string>? _model;

    /// <summary>
    /// The SKU capacity.
    /// </summary>
    public BicepValue<int> Capacity 
    {
        get { Initialize(); return _capacity!; }
        set { Initialize(); _capacity!.Assign(value); }
    }
    private BicepValue<int>? _capacity;

    /// <summary>
    /// Creates a new ArmApplicationSku.
    /// </summary>
    public ArmApplicationSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmApplicationSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _tier = DefineProperty<string>("Tier", ["tier"]);
        _size = DefineProperty<string>("Size", ["size"]);
        _family = DefineProperty<string>("Family", ["family"]);
        _model = DefineProperty<string>("Model", ["model"]);
        _capacity = DefineProperty<int>("Capacity", ["capacity"]);
    }
}
