// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Managed application policy.
/// </summary>
public partial class ArmApplicationPolicy : ProvisionableConstruct
{
    /// <summary>
    /// The policy name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The policy definition Id.
    /// </summary>
    public BicepValue<string> PolicyDefinitionId 
    {
        get { Initialize(); return _policyDefinitionId!; }
        set { Initialize(); _policyDefinitionId!.Assign(value); }
    }
    private BicepValue<string>? _policyDefinitionId;

    /// <summary>
    /// The policy parameters.
    /// </summary>
    public BicepValue<string> Parameters 
    {
        get { Initialize(); return _parameters!; }
        set { Initialize(); _parameters!.Assign(value); }
    }
    private BicepValue<string>? _parameters;

    /// <summary>
    /// Creates a new ArmApplicationPolicy.
    /// </summary>
    public ArmApplicationPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmApplicationPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _policyDefinitionId = DefineProperty<string>("PolicyDefinitionId", ["policyDefinitionId"]);
        _parameters = DefineProperty<string>("Parameters", ["parameters"]);
    }
}
