// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The appliance package support URLs.
/// </summary>
public partial class ArmApplicationPackageSupportUris : ProvisionableConstruct
{
    /// <summary>
    /// The public azure support URL.
    /// </summary>
    public BicepValue<Uri> AzurePublicCloudUri 
    {
        get { Initialize(); return _azurePublicCloudUri!; }
    }
    private BicepValue<Uri>? _azurePublicCloudUri;

    /// <summary>
    /// The government cloud support URL.
    /// </summary>
    public BicepValue<Uri> AzureGovernmentUri 
    {
        get { Initialize(); return _azureGovernmentUri!; }
    }
    private BicepValue<Uri>? _azureGovernmentUri;

    /// <summary>
    /// Creates a new ArmApplicationPackageSupportUris.
    /// </summary>
    public ArmApplicationPackageSupportUris()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ArmApplicationPackageSupportUris.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _azurePublicCloudUri = DefineProperty<Uri>("AzurePublicCloudUri", ["publicAzure"], isOutput: true);
        _azureGovernmentUri = DefineProperty<Uri>("AzureGovernmentUri", ["governmentCloud"], isOutput: true);
    }
}
