// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Managed application locking policy.
/// </summary>
public partial class ArmApplicationPackageLockingPolicy : ProvisionableConstruct
{
    /// <summary>
    /// The deny assignment excluded actions.
    /// </summary>
    public BicepList<string> AllowedActions 
    {
        get { Initialize(); return _allowedActions!; }
        set { Initialize(); _allowedActions!.Assign(value); }
    }
    private BicepList<string>? _allowedActions;

    /// <summary>
    /// The deny assignment excluded data actions.
    /// </summary>
    public BicepList<string> AllowedDataActions 
    {
        get { Initialize(); return _allowedDataActions!; }
        set { Initialize(); _allowedDataActions!.Assign(value); }
    }
    private BicepList<string>? _allowedDataActions;

    /// <summary>
    /// Creates a new ArmApplicationPackageLockingPolicy.
    /// </summary>
    public ArmApplicationPackageLockingPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ArmApplicationPackageLockingPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _allowedActions = DefineListProperty<string>("AllowedActions", ["allowedActions"]);
        _allowedDataActions = DefineListProperty<string>("AllowedDataActions", ["allowedDataActions"]);
    }
}
