// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The application package contact information.
/// </summary>
public partial class ArmApplicationPackageContact : ProvisionableConstruct
{
    /// <summary>
    /// The contact name.
    /// </summary>
    public BicepValue<string> ContactName 
    {
        get { Initialize(); return _contactName!; }
    }
    private BicepValue<string>? _contactName;

    /// <summary>
    /// The contact email.
    /// </summary>
    public BicepValue<string> Email 
    {
        get { Initialize(); return _email!; }
    }
    private BicepValue<string>? _email;

    /// <summary>
    /// The contact phone number.
    /// </summary>
    public BicepValue<string> Phone 
    {
        get { Initialize(); return _phone!; }
    }
    private BicepValue<string>? _phone;

    /// <summary>
    /// Creates a new ArmApplicationPackageContact.
    /// </summary>
    public ArmApplicationPackageContact()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmApplicationPackageContact.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _contactName = DefineProperty<string>("ContactName", ["contactName"], isOutput: true);
        _email = DefineProperty<string>("Email", ["email"], isOutput: true);
        _phone = DefineProperty<string>("Phone", ["phone"], isOutput: true);
    }
}
