// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Managed application notification endpoint.
/// </summary>
public partial class ArmApplicationNotificationEndpoint : ProvisionableConstruct
{
    /// <summary>
    /// The managed application notification endpoint uri.
    /// </summary>
    public BicepValue<Uri> Uri 
    {
        get { Initialize(); return _uri!; }
        set { Initialize(); _uri!.Assign(value); }
    }
    private BicepValue<Uri>? _uri;

    /// <summary>
    /// Creates a new ArmApplicationNotificationEndpoint.
    /// </summary>
    public ArmApplicationNotificationEndpoint()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ArmApplicationNotificationEndpoint.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _uri = DefineProperty<Uri>("Uri", ["uri"]);
    }
}
