// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Identity for the resource.
/// </summary>
public partial class ArmApplicationManagedIdentity : ProvisionableConstruct
{
    /// <summary>
    /// The principal ID of resource identity.
    /// </summary>
    public BicepValue<Guid> PrincipalId 
    {
        get { Initialize(); return _principalId!; }
    }
    private BicepValue<Guid>? _principalId;

    /// <summary>
    /// The tenant ID of resource.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// The identity type.
    /// </summary>
    public BicepValue<ArmApplicationManagedIdentityType> IdentityType 
    {
        get { Initialize(); return _identityType!; }
        set { Initialize(); _identityType!.Assign(value); }
    }
    private BicepValue<ArmApplicationManagedIdentityType>? _identityType;

    /// <summary>
    /// The list of user identities associated with the resource. The user
    /// identity dictionary key references will be resource ids in the form:
    /// &apos;/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}&apos;.
    /// </summary>
    public BicepDictionary<ArmApplicationUserAssignedIdentity> UserAssignedIdentities 
    {
        get { Initialize(); return _userAssignedIdentities!; }
        set { Initialize(); _userAssignedIdentities!.Assign(value); }
    }
    private BicepDictionary<ArmApplicationUserAssignedIdentity>? _userAssignedIdentities;

    /// <summary>
    /// Creates a new ArmApplicationManagedIdentity.
    /// </summary>
    public ArmApplicationManagedIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ArmApplicationManagedIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _principalId = DefineProperty<Guid>("PrincipalId", ["principalId"], isOutput: true);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"], isOutput: true);
        _identityType = DefineProperty<ArmApplicationManagedIdentityType>("IdentityType", ["type"]);
        _userAssignedIdentities = DefineDictionaryProperty<ArmApplicationUserAssignedIdentity>("UserAssignedIdentities", ["userAssignedIdentities"]);
    }
}
