// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Managed application Jit access policy.
/// </summary>
public partial class ArmApplicationJitAccessPolicy : ProvisionableConstruct
{
    /// <summary>
    /// Whether the JIT access is enabled.
    /// </summary>
    public BicepValue<bool> JitAccessEnabled 
    {
        get { Initialize(); return _jitAccessEnabled!; }
        set { Initialize(); _jitAccessEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _jitAccessEnabled;

    /// <summary>
    /// JIT approval mode.
    /// </summary>
    public BicepValue<JitApprovalMode> JitApprovalMode 
    {
        get { Initialize(); return _jitApprovalMode!; }
        set { Initialize(); _jitApprovalMode!.Assign(value); }
    }
    private BicepValue<JitApprovalMode>? _jitApprovalMode;

    /// <summary>
    /// The JIT approvers.
    /// </summary>
    public BicepList<JitApprover> JitApprovers 
    {
        get { Initialize(); return _jitApprovers!; }
        set { Initialize(); _jitApprovers!.Assign(value); }
    }
    private BicepList<JitApprover>? _jitApprovers;

    /// <summary>
    /// The maximum duration JIT access is granted. This is an ISO8601 time
    /// period value.
    /// </summary>
    public BicepValue<TimeSpan> MaximumJitAccessDuration 
    {
        get { Initialize(); return _maximumJitAccessDuration!; }
        set { Initialize(); _maximumJitAccessDuration!.Assign(value); }
    }
    private BicepValue<TimeSpan>? _maximumJitAccessDuration;

    /// <summary>
    /// Creates a new ArmApplicationJitAccessPolicy.
    /// </summary>
    public ArmApplicationJitAccessPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ArmApplicationJitAccessPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _jitAccessEnabled = DefineProperty<bool>("JitAccessEnabled", ["jitAccessEnabled"]);
        _jitApprovalMode = DefineProperty<JitApprovalMode>("JitApprovalMode", ["jitApprovalMode"]);
        _jitApprovers = DefineListProperty<JitApprover>("JitApprovers", ["jitApprovers"]);
        _maximumJitAccessDuration = DefineProperty<TimeSpan>("MaximumJitAccessDuration", ["maximumJitAccessDuration"], format: "P");
    }
}
