// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The application client details to track the entity creating/updating the
/// managed app resource.
/// </summary>
public partial class ArmApplicationDetails : ProvisionableConstruct
{
    /// <summary>
    /// The client Oid.
    /// </summary>
    public BicepValue<Guid> ObjectId 
    {
        get { Initialize(); return _objectId!; }
    }
    private BicepValue<Guid>? _objectId;

    /// <summary>
    /// The client Puid.
    /// </summary>
    public BicepValue<string> Puid 
    {
        get { Initialize(); return _puid!; }
    }
    private BicepValue<string>? _puid;

    /// <summary>
    /// The client application Id.
    /// </summary>
    public BicepValue<Guid> ApplicationId 
    {
        get { Initialize(); return _applicationId!; }
    }
    private BicepValue<Guid>? _applicationId;

    /// <summary>
    /// Creates a new ArmApplicationDetails.
    /// </summary>
    public ArmApplicationDetails()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmApplicationDetails.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _objectId = DefineProperty<Guid>("ObjectId", ["oid"], isOutput: true);
        _puid = DefineProperty<string>("Puid", ["puid"], isOutput: true);
        _applicationId = DefineProperty<Guid>("ApplicationId", ["applicationId"], isOutput: true);
    }
}
