// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// The managed application provider authorization.
/// </summary>
public partial class ArmApplicationAuthorization : ProvisionableConstruct
{
    /// <summary>
    /// The provider&apos;s principal identifier. This is the identity that the
    /// provider will use to call ARM to manage the managed application
    /// resources.
    /// </summary>
    public BicepValue<Guid> PrincipalId 
    {
        get { Initialize(); return _principalId!; }
        set { Initialize(); _principalId!.Assign(value); }
    }
    private BicepValue<Guid>? _principalId;

    /// <summary>
    /// The provider&apos;s role definition identifier. This role will define
    /// all the permissions that the provider must have on the managed
    /// application&apos;s container resource group. This role definition
    /// cannot have permission to delete the resource group.
    /// </summary>
    public BicepValue<string> RoleDefinitionId 
    {
        get { Initialize(); return _roleDefinitionId!; }
        set { Initialize(); _roleDefinitionId!.Assign(value); }
    }
    private BicepValue<string>? _roleDefinitionId;

    /// <summary>
    /// Creates a new ArmApplicationAuthorization.
    /// </summary>
    public ArmApplicationAuthorization()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmApplicationAuthorization.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _principalId = DefineProperty<Guid>("PrincipalId", ["principalId"]);
        _roleDefinitionId = DefineProperty<string>("RoleDefinitionId", ["roleDefinitionId"]);
    }
}
