// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// Managed application artifact.
/// </summary>
public partial class ArmApplicationArtifact : ProvisionableConstruct
{
    /// <summary>
    /// The managed application artifact name.
    /// </summary>
    public BicepValue<ArmApplicationArtifactName> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<ArmApplicationArtifactName>? _name;

    /// <summary>
    /// The managed application artifact blob uri.
    /// </summary>
    public BicepValue<Uri> Uri 
    {
        get { Initialize(); return _uri!; }
    }
    private BicepValue<Uri>? _uri;

    /// <summary>
    /// The managed application artifact type.
    /// </summary>
    public BicepValue<ArmApplicationArtifactType> ArtifactType 
    {
        get { Initialize(); return _artifactType!; }
    }
    private BicepValue<ArmApplicationArtifactType>? _artifactType;

    /// <summary>
    /// Creates a new ArmApplicationArtifact.
    /// </summary>
    public ArmApplicationArtifact()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmApplicationArtifact.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<ArmApplicationArtifactName>("Name", ["name"], isOutput: true);
        _uri = DefineProperty<Uri>("Uri", ["uri"], isOutput: true);
        _artifactType = DefineProperty<ArmApplicationArtifactType>("ArtifactType", ["type"], isOutput: true);
    }
}
