// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// ApiProfile.
/// </summary>
public partial class ApiProfile : ProvisionableConstruct
{
    /// <summary>
    /// Gets the ProfileVersion.
    /// </summary>
    public BicepValue<string> ProfileVersion 
    {
        get { Initialize(); return _profileVersion!; }
    }
    private BicepValue<string>? _profileVersion;

    /// <summary>
    /// Gets the ApiVersion.
    /// </summary>
    public BicepValue<string> ApiVersion 
    {
        get { Initialize(); return _apiVersion!; }
    }
    private BicepValue<string>? _apiVersion;

    /// <summary>
    /// Creates a new ApiProfile.
    /// </summary>
    public ApiProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ApiProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _profileVersion = DefineProperty<string>("ProfileVersion", ["profileVersion"], isOutput: true);
        _apiVersion = DefineProperty<string>("ApiVersion", ["apiVersion"], isOutput: true);
    }
}
