// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Resources;

/// <summary>
/// ManagementLock.
/// </summary>
public partial class ManagementLock : ProvisionableResource
{
    /// <summary>
    /// The name of lock.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The level of the lock. Possible values are: NotSpecified, CanNotDelete,
    /// ReadOnly. CanNotDelete means authorized users are able to read and
    /// modify the resources, but not delete. ReadOnly means authorized users
    /// can only read from a resource, but they can&apos;t modify or delete it.
    /// </summary>
    public BicepValue<ManagementLockLevel> Level 
    {
        get { Initialize(); return _level!; }
        set { Initialize(); _level!.Assign(value); }
    }
    private BicepValue<ManagementLockLevel>? _level;

    /// <summary>
    /// Notes about the lock. Maximum of 512 characters.
    /// </summary>
    public BicepValue<string> Notes 
    {
        get { Initialize(); return _notes!; }
        set { Initialize(); _notes!.Assign(value); }
    }
    private BicepValue<string>? _notes;

    /// <summary>
    /// The owners of the lock.
    /// </summary>
    public BicepList<ManagementLockOwner> Owners 
    {
        get { Initialize(); return _owners!; }
        set { Initialize(); _owners!.Assign(value); }
    }
    private BicepList<ManagementLockOwner>? _owners;

    /// <summary>
    /// Fully qualified resource ID for the resource. Ex -
    /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Azure Resource Manager metadata containing createdBy and modifiedBy
    /// information.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new ManagementLock.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagementLock resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagementLock.</param>
    public ManagementLock(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Authorization/locks", resourceVersion ?? "2020-05-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementLock.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _level = DefineProperty<ManagementLockLevel>("Level", ["properties", "level"], isRequired: true);
        _notes = DefineProperty<string>("Notes", ["properties", "notes"]);
        _owners = DefineListProperty<ManagementLockOwner>("Owners", ["properties", "owners"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported ManagementLock resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2020-05-01.
        /// </summary>
        public static readonly string V2020_05_01 = "2020-05-01";

        /// <summary>
        /// 2017-04-01.
        /// </summary>
        public static readonly string V2017_04_01 = "2017-04-01";

        /// <summary>
        /// 2016-09-01.
        /// </summary>
        public static readonly string V2016_09_01 = "2016-09-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";

        /// <summary>
        /// 2015-01-01.
        /// </summary>
        public static readonly string V2015_01_01 = "2015-01-01";
    }

    /// <summary>
    /// Creates a reference to an existing ManagementLock.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagementLock resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagementLock.</param>
    /// <returns>The existing ManagementLock resource.</returns>
    public static ManagementLock FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this ManagementLock resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 90, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen | ResourceNameCharacters.Underscore | ResourceNameCharacters.Period);
}
