// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// ManagementGroupSubscription.
/// </summary>
public partial class ManagementGroupSubscription : ProvisionableResource
{
    /// <summary>
    /// The name of the resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The friendly name of the subscription.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// Fully qualified resource ID for the resource. Ex -
    /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The fully qualified ID for the parent management group.  For example,
    /// /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    /// </summary>
    public BicepValue<ResourceIdentifier> ParentId 
    {
        get { Initialize(); return _parentId!; }
    }
    private BicepValue<ResourceIdentifier>? _parentId;

    /// <summary>
    /// The state of the subscription.
    /// </summary>
    public BicepValue<string> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<string>? _state;

    /// <summary>
    /// Azure Resource Manager metadata containing createdBy and modifiedBy
    /// information.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// The AAD Tenant ID associated with the subscription. For example,
    /// 00000000-0000-0000-0000-000000000000.
    /// </summary>
    public BicepValue<string> Tenant 
    {
        get { Initialize(); return _tenant!; }
    }
    private BicepValue<string>? _tenant;

    /// <summary>
    /// Gets or sets a reference to the parent ManagementGroup.
    /// </summary>
    public ManagementGroup? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ManagementGroup>? _parent;

    /// <summary>
    /// Creates a new ManagementGroupSubscription.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagementGroupSubscription
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagementGroupSubscription.</param>
    public ManagementGroupSubscription(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Management/managementGroups/subscriptions", resourceVersion ?? "2023-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementGroupSubscription.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _displayName = DefineProperty<string>("DisplayName", ["properties", "displayName"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _parentId = DefineProperty<ResourceIdentifier>("ParentId", ["properties", "parent", "id"], isOutput: true);
        _state = DefineProperty<string>("State", ["properties", "state"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _tenant = DefineProperty<string>("Tenant", ["properties", "tenant"], isOutput: true);
        _parent = DefineResource<ManagementGroup>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ManagementGroupSubscription resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2021-04-01.
        /// </summary>
        public static readonly string V2021_04_01 = "2021-04-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-05-01.
        /// </summary>
        public static readonly string V2020_05_01 = "2020-05-01";

        /// <summary>
        /// 2020-02-01.
        /// </summary>
        public static readonly string V2020_02_01 = "2020-02-01";

        /// <summary>
        /// 2019-11-01.
        /// </summary>
        public static readonly string V2019_11_01 = "2019-11-01";

        /// <summary>
        /// 2018-03-01-beta.
        /// </summary>
        public static readonly string V2018_03_01_beta = "2018-03-01-beta";
    }

    /// <summary>
    /// Creates a reference to an existing ManagementGroupSubscription.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagementGroupSubscription
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagementGroupSubscription.</param>
    /// <returns>The existing ManagementGroupSubscription resource.</returns>
    public static ManagementGroupSubscription FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
