// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Resources;

/// <summary>
/// ManagementGroup.
/// </summary>
public partial class ManagementGroup : ProvisionableResource
{
    /// <summary>
    /// The name of the management group. For example,
    /// 00000000-0000-0000-0000-000000000000.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The details of a management group used during creation.
    /// </summary>
    public CreateManagementGroupDetails Details 
    {
        get { Initialize(); return _details!; }
        set { Initialize(); AssignOrReplace(ref _details, value); }
    }
    private CreateManagementGroupDetails? _details;

    /// <summary>
    /// The friendly name of the management group. If no value is passed then
    /// this  field will be set to the groupId.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
        set { Initialize(); _displayName!.Assign(value); }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// The list of children.
    /// </summary>
    public BicepList<ManagementGroupChildOptions> Children 
    {
        get { Initialize(); return _children!; }
    }
    private BicepList<ManagementGroupChildOptions>? _children;

    /// <summary>
    /// The fully qualified ID for the management group.  For example,
    /// /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// Azure Resource Manager metadata containing createdBy and modifiedBy
    /// information.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// The AAD Tenant ID associated with the management group. For example,
    /// 00000000-0000-0000-0000-000000000000.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Creates a new ManagementGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagementGroup resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagementGroup.</param>
    public ManagementGroup(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Management/managementGroups", resourceVersion ?? "2023-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementGroup.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"]);
        _details = DefineModelProperty<CreateManagementGroupDetails>("Details", ["properties", "details"]);
        _displayName = DefineProperty<string>("DisplayName", ["properties", "displayName"]);
        _children = DefineListProperty<ManagementGroupChildOptions>("Children", ["properties", "children"], isOutput: true);
        _id = DefineProperty<string>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _tenantId = DefineProperty<Guid>("TenantId", ["properties", "tenantId"], isOutput: true);
    }

    /// <summary>
    /// Supported ManagementGroup resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2021-04-01.
        /// </summary>
        public static readonly string V2021_04_01 = "2021-04-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-05-01.
        /// </summary>
        public static readonly string V2020_05_01 = "2020-05-01";

        /// <summary>
        /// 2020-02-01.
        /// </summary>
        public static readonly string V2020_02_01 = "2020-02-01";

        /// <summary>
        /// 2019-11-01.
        /// </summary>
        public static readonly string V2019_11_01 = "2019-11-01";

        /// <summary>
        /// 2018-03-01-beta.
        /// </summary>
        public static readonly string V2018_03_01_beta = "2018-03-01-beta";
    }

    /// <summary>
    /// Creates a reference to an existing ManagementGroup.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ManagementGroup resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ManagementGroup.</param>
    /// <returns>The existing ManagementGroup resource.</returns>
    public static ManagementGroup FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this ManagementGroup resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 90, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen | ResourceNameCharacters.Underscore | ResourceNameCharacters.Period | ResourceNameCharacters.Parentheses);
}
