// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Roles;

/// <summary>
/// FederatedIdentityCredential.
/// </summary>
public partial class FederatedIdentityCredential : ProvisionableResource
{
    /// <summary>
    /// The name of the federated identity credential resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The list of audiences that can appear in the issued token.
    /// </summary>
    public BicepList<string> Audiences 
    {
        get { Initialize(); return _audiences!; }
        set { Initialize(); _audiences!.Assign(value); }
    }
    private BicepList<string>? _audiences;

    /// <summary>
    /// The URL of the issuer to be trusted.
    /// </summary>
    public BicepValue<Uri> IssuerUri 
    {
        get { Initialize(); return _issuerUri!; }
        set { Initialize(); _issuerUri!.Assign(value); }
    }
    private BicepValue<Uri>? _issuerUri;

    /// <summary>
    /// The identifier of the external identity.
    /// </summary>
    public BicepValue<string> Subject 
    {
        get { Initialize(); return _subject!; }
        set { Initialize(); _subject!.Assign(value); }
    }
    private BicepValue<string>? _subject;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent UserAssignedIdentity.
    /// </summary>
    public UserAssignedIdentity? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<UserAssignedIdentity>? _parent;

    /// <summary>
    /// Creates a new FederatedIdentityCredential.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the FederatedIdentityCredential
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the FederatedIdentityCredential.</param>
    public FederatedIdentityCredential(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.ManagedIdentity/userAssignedIdentities/federatedIdentityCredentials", resourceVersion ?? "2023-01-31")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of FederatedIdentityCredential.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _audiences = DefineListProperty<string>("Audiences", ["properties", "audiences"]);
        _issuerUri = DefineProperty<Uri>("IssuerUri", ["properties", "issuer"]);
        _subject = DefineProperty<string>("Subject", ["properties", "subject"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<UserAssignedIdentity>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported FederatedIdentityCredential resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-07-31-PREVIEW.
        /// </summary>
        public static readonly string V2023_07_31_PREVIEW = "2023-07-31-PREVIEW";

        /// <summary>
        /// 2023-01-31.
        /// </summary>
        public static readonly string V2023_01_31 = "2023-01-31";

        /// <summary>
        /// 2022-01-31-PREVIEW.
        /// </summary>
        public static readonly string V2022_01_31_PREVIEW = "2022-01-31-PREVIEW";
    }

    /// <summary>
    /// Creates a reference to an existing FederatedIdentityCredential.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the FederatedIdentityCredential
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the FederatedIdentityCredential.</param>
    /// <returns>The existing FederatedIdentityCredential resource.</returns>
    public static FederatedIdentityCredential FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
