// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Authorization;

/// <summary>
/// AuthorizationRoleDefinition.
/// </summary>
public partial class AuthorizationRoleDefinition : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Role definition assignable scopes.
    /// </summary>
    public BicepList<string> AssignableScopes 
    {
        get { Initialize(); return _assignableScopes!; }
        set { Initialize(); _assignableScopes!.Assign(value); }
    }
    private BicepList<string>? _assignableScopes;

    /// <summary>
    /// The role definition description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Role definition permissions.
    /// </summary>
    public BicepList<RoleDefinitionPermission> Permissions 
    {
        get { Initialize(); return _permissions!; }
        set { Initialize(); _permissions!.Assign(value); }
    }
    private BicepList<RoleDefinitionPermission>? _permissions;

    /// <summary>
    /// The role name.
    /// </summary>
    public BicepValue<string> RoleName 
    {
        get { Initialize(); return _roleName!; }
        set { Initialize(); _roleName!.Assign(value); }
    }
    private BicepValue<string>? _roleName;

    /// <summary>
    /// The role type.
    /// </summary>
    public BicepValue<AuthorizationRoleType> RoleType 
    {
        get { Initialize(); return _roleType!; }
        set { Initialize(); _roleType!.Assign(value); }
    }
    private BicepValue<AuthorizationRoleType>? _roleType;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Get the default value for the Name property.
    /// </summary>
    private partial BicepValue<string> GetNameDefaultValue();

    /// <summary>
    /// Creates a new AuthorizationRoleDefinition.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AuthorizationRoleDefinition
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AuthorizationRoleDefinition.</param>
    public AuthorizationRoleDefinition(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Authorization/roleDefinitions", resourceVersion ?? "2022-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AuthorizationRoleDefinition.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true, defaultValue: GetNameDefaultValue());
        _assignableScopes = DefineListProperty<string>("AssignableScopes", ["properties", "assignableScopes"]);
        _description = DefineProperty<string>("Description", ["properties", "description"]);
        _permissions = DefineListProperty<RoleDefinitionPermission>("Permissions", ["properties", "permissions"]);
        _roleName = DefineProperty<string>("RoleName", ["properties", "roleName"]);
        _roleType = DefineProperty<AuthorizationRoleType>("RoleType", ["properties", "type"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported AuthorizationRoleDefinition resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2022-04-01.
        /// </summary>
        public static readonly string V2022_04_01 = "2022-04-01";

        /// <summary>
        /// 2018-07-01.
        /// </summary>
        public static readonly string V2018_07_01 = "2018-07-01";

        /// <summary>
        /// 2017-09-01.
        /// </summary>
        public static readonly string V2017_09_01 = "2017-09-01";

        /// <summary>
        /// 2017-05-01.
        /// </summary>
        public static readonly string V2017_05_01 = "2017-05-01";

        /// <summary>
        /// 2016-07-01.
        /// </summary>
        public static readonly string V2016_07_01 = "2016-07-01";

        /// <summary>
        /// 2015-07-01.
        /// </summary>
        public static readonly string V2015_07_01 = "2015-07-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";
    }

    /// <summary>
    /// Creates a reference to an existing AuthorizationRoleDefinition.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AuthorizationRoleDefinition
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AuthorizationRoleDefinition.</param>
    /// <returns>The existing AuthorizationRoleDefinition resource.</returns>
    public static AuthorizationRoleDefinition FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
