// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Resources;

/// <summary>
/// ArmApplicationDefinition.
/// </summary>
public partial class ArmApplicationDefinition : ProvisionableResource
{
    /// <summary>
    /// The name of the managed application definition.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// The managed application lock level.
    /// </summary>
    public BicepValue<ArmApplicationLockLevel> LockLevel 
    {
        get { Initialize(); return _lockLevel!; }
        set { Initialize(); _lockLevel!.Assign(value); }
    }
    private BicepValue<ArmApplicationLockLevel>? _lockLevel;

    /// <summary>
    /// The collection of managed application artifacts. The portal will use
    /// the files specified as artifacts to construct the user experience of
    /// creating a managed application from a managed application definition.
    /// </summary>
    public BicepList<ArmApplicationDefinitionArtifact> Artifacts 
    {
        get { Initialize(); return _artifacts!; }
        set { Initialize(); _artifacts!.Assign(value); }
    }
    private BicepList<ArmApplicationDefinitionArtifact>? _artifacts;

    /// <summary>
    /// The managed application provider authorizations.
    /// </summary>
    public BicepList<ArmApplicationAuthorization> Authorizations 
    {
        get { Initialize(); return _authorizations!; }
        set { Initialize(); _authorizations!.Assign(value); }
    }
    private BicepList<ArmApplicationAuthorization>? _authorizations;

    /// <summary>
    /// The createUiDefinition json for the backing template with
    /// Microsoft.Solutions/applications resource. It can be a JObject or
    /// well-formed JSON string.                          To assign an object
    /// to this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepValue<BinaryData> CreateUiDefinition 
    {
        get { Initialize(); return _createUiDefinition!; }
        set { Initialize(); _createUiDefinition!.Assign(value); }
    }
    private BicepValue<BinaryData>? _createUiDefinition;

    /// <summary>
    /// The managed application definition description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// The managed application definition display name.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
        set { Initialize(); _displayName!.Assign(value); }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// A value indicating whether the package is enabled or not.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// The managed application locking policy.
    /// </summary>
    public ArmApplicationPackageLockingPolicy LockingPolicy 
    {
        get { Initialize(); return _lockingPolicy!; }
        set { Initialize(); AssignOrReplace(ref _lockingPolicy, value); }
    }
    private ArmApplicationPackageLockingPolicy? _lockingPolicy;

    /// <summary>
    /// The inline main template json which has resources to be provisioned. It
    /// can be a JObject or well-formed JSON string.
    /// To assign an object to this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepValue<BinaryData> MainTemplate 
    {
        get { Initialize(); return _mainTemplate!; }
        set { Initialize(); _mainTemplate!.Assign(value); }
    }
    private BicepValue<BinaryData>? _mainTemplate;

    /// <summary>
    /// ID of the resource that manages this resource.
    /// </summary>
    public BicepValue<string> ManagedBy 
    {
        get { Initialize(); return _managedBy!; }
        set { Initialize(); _managedBy!.Assign(value); }
    }
    private BicepValue<string>? _managedBy;

    /// <summary>
    /// The managed application management mode.
    /// </summary>
    public BicepValue<ArmApplicationManagementMode> ManagementMode 
    {
        get { Initialize(); return _managementMode!; }
        set { Initialize(); _managementMode!.Assign(value); }
    }
    private BicepValue<ArmApplicationManagementMode>? _managementMode;

    /// <summary>
    /// The managed application notification endpoint.
    /// </summary>
    public BicepList<ArmApplicationNotificationEndpoint> NotificationEndpoints 
    {
        get { Initialize(); return _notificationEndpoints!; }
        set { Initialize(); _notificationEndpoints!.Assign(value); }
    }
    private BicepList<ArmApplicationNotificationEndpoint>? _notificationEndpoints;

    /// <summary>
    /// The managed application definition package file Uri. Use this element.
    /// </summary>
    public BicepValue<Uri> PackageFileUri 
    {
        get { Initialize(); return _packageFileUri!; }
        set { Initialize(); _packageFileUri!.Assign(value); }
    }
    private BicepValue<Uri>? _packageFileUri;

    /// <summary>
    /// The managed application provider policies.
    /// </summary>
    public BicepList<ArmApplicationPolicy> Policies 
    {
        get { Initialize(); return _policies!; }
        set { Initialize(); _policies!.Assign(value); }
    }
    private BicepList<ArmApplicationPolicy>? _policies;

    /// <summary>
    /// The SKU of the resource.
    /// </summary>
    public ArmApplicationSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private ArmApplicationSku? _sku;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new ArmApplicationDefinition.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ArmApplicationDefinition resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ArmApplicationDefinition.</param>
    public ArmApplicationDefinition(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Solutions/applicationDefinitions", resourceVersion ?? "2021-07-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArmApplicationDefinition.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _lockLevel = DefineProperty<ArmApplicationLockLevel>("LockLevel", ["properties", "lockLevel"], isRequired: true);
        _artifacts = DefineListProperty<ArmApplicationDefinitionArtifact>("Artifacts", ["properties", "artifacts"]);
        _authorizations = DefineListProperty<ArmApplicationAuthorization>("Authorizations", ["properties", "authorizations"]);
        _createUiDefinition = DefineProperty<BinaryData>("CreateUiDefinition", ["properties", "createUiDefinition"]);
        _description = DefineProperty<string>("Description", ["properties", "description"]);
        _displayName = DefineProperty<string>("DisplayName", ["properties", "displayName"]);
        _isEnabled = DefineProperty<bool>("IsEnabled", ["properties", "isEnabled"]);
        _lockingPolicy = DefineModelProperty<ArmApplicationPackageLockingPolicy>("LockingPolicy", ["properties", "lockingPolicy"]);
        _mainTemplate = DefineProperty<BinaryData>("MainTemplate", ["properties", "mainTemplate"]);
        _managedBy = DefineProperty<string>("ManagedBy", ["managedBy"]);
        _managementMode = DefineProperty<ArmApplicationManagementMode>("ManagementMode", ["properties", "managementPolicy", "mode"]);
        _notificationEndpoints = DefineListProperty<ArmApplicationNotificationEndpoint>("NotificationEndpoints", ["properties", "notificationPolicy", "notificationEndpoints"]);
        _packageFileUri = DefineProperty<Uri>("PackageFileUri", ["properties", "packageFileUri"]);
        _policies = DefineListProperty<ArmApplicationPolicy>("Policies", ["properties", "policies"]);
        _sku = DefineModelProperty<ArmApplicationSku>("Sku", ["sku"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported ArmApplicationDefinition resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-07-01.
        /// </summary>
        public static readonly string V2021_07_01 = "2021-07-01";

        /// <summary>
        /// 2019-07-01.
        /// </summary>
        public static readonly string V2019_07_01 = "2019-07-01";

        /// <summary>
        /// 2018-06-01.
        /// </summary>
        public static readonly string V2018_06_01 = "2018-06-01";

        /// <summary>
        /// 2018-03-01.
        /// </summary>
        public static readonly string V2018_03_01 = "2018-03-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-12-01.
        /// </summary>
        public static readonly string V2017_12_01 = "2017-12-01";

        /// <summary>
        /// 2017-09-01.
        /// </summary>
        public static readonly string V2017_09_01 = "2017-09-01";
    }

    /// <summary>
    /// Creates a reference to an existing ArmApplicationDefinition.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ArmApplicationDefinition resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ArmApplicationDefinition.</param>
    /// <returns>The existing ArmApplicationDefinition resource.</returns>
    public static ArmApplicationDefinition FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
