// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.WebPubSub;

/// <summary>
/// WebPubSubSharedPrivateLink.
/// </summary>
public partial class WebPubSubSharedPrivateLink : ProvisionableResource
{
    /// <summary>
    /// The name of the shared private link resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The group id from the provider of resource the shared private link
    /// resource is for.
    /// </summary>
    public BicepValue<string> GroupId 
    {
        get { Initialize(); return _groupId!; }
        set { Initialize(); _groupId!.Assign(value); }
    }
    private BicepValue<string>? _groupId;

    /// <summary>
    /// The resource id of the resource the shared private link resource is for.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrivateLinkResourceId 
    {
        get { Initialize(); return _privateLinkResourceId!; }
        set { Initialize(); _privateLinkResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _privateLinkResourceId;

    /// <summary>
    /// The request message for requesting approval of the shared private link
    /// resource.
    /// </summary>
    public BicepValue<string> RequestMessage 
    {
        get { Initialize(); return _requestMessage!; }
        set { Initialize(); _requestMessage!.Assign(value); }
    }
    private BicepValue<string>? _requestMessage;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Provisioning state of the resource.
    /// </summary>
    public BicepValue<WebPubSubProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<WebPubSubProvisioningState>? _provisioningState;

    /// <summary>
    /// Status of the shared private link resource.
    /// </summary>
    public BicepValue<WebPubSubSharedPrivateLinkStatus> Status 
    {
        get { Initialize(); return _status!; }
    }
    private BicepValue<WebPubSubSharedPrivateLinkStatus>? _status;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent WebPubSubService.
    /// </summary>
    public WebPubSubService? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<WebPubSubService>? _parent;

    /// <summary>
    /// Creates a new WebPubSubSharedPrivateLink.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the WebPubSubSharedPrivateLink
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the WebPubSubSharedPrivateLink.</param>
    public WebPubSubSharedPrivateLink(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.SignalRService/webPubSub/sharedPrivateLinkResources", resourceVersion ?? "2024-03-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WebPubSubSharedPrivateLink.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _groupId = DefineProperty<string>("GroupId", ["properties", "groupId"]);
        _privateLinkResourceId = DefineProperty<ResourceIdentifier>("PrivateLinkResourceId", ["properties", "privateLinkResourceId"]);
        _requestMessage = DefineProperty<string>("RequestMessage", ["properties", "requestMessage"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<WebPubSubProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _status = DefineProperty<WebPubSubSharedPrivateLinkStatus>("Status", ["properties", "status"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<WebPubSubService>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported WebPubSubSharedPrivateLink resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-03-01.
        /// </summary>
        public static readonly string V2024_03_01 = "2024-03-01";

        /// <summary>
        /// 2023-02-01.
        /// </summary>
        public static readonly string V2023_02_01 = "2023-02-01";

        /// <summary>
        /// 2021-10-01.
        /// </summary>
        public static readonly string V2021_10_01 = "2021-10-01";

        /// <summary>
        /// 2020-05-01.
        /// </summary>
        public static readonly string V2020_05_01 = "2020-05-01";
    }

    /// <summary>
    /// Creates a reference to an existing WebPubSubSharedPrivateLink.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the WebPubSubSharedPrivateLink
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the WebPubSubSharedPrivateLink.</param>
    /// <returns>The existing WebPubSubSharedPrivateLink resource.</returns>
    public static WebPubSubSharedPrivateLink FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
